﻿using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace TaiVietKey
{
    public class HotkeyWindow : NativeWindow, IDisposable
    {
        private const int WM_HOTKEY = 0x0312;
        public event Action OnToggleHotkeyPressed;

        public HotkeyWindow()
        {
            CreateHandle(new CreateParams()); // tạo handle ẩn
        }

        public void RegisterHotkey()
        {
            RegisterHotKey(this.Handle, 1, MOD_CONTROL | MOD_ALT, VK_X);
        }

        public void UnregisterHotkey()
        {
            UnregisterHotKey(this.Handle, 1);
        }

        protected override void WndProc(ref Message m)
        {
            if (m.Msg == WM_HOTKEY)
            {
                OnToggleHotkeyPressed?.Invoke();
            }
            base.WndProc(ref m);
        }

        public void Dispose()
        {
            UnregisterHotkey();
            this.DestroyHandle();
        }

        // WinAPI
        private const uint MOD_CONTROL = 0x0002;
        private const uint MOD_ALT = 0x0001;
        private const uint VK_X = 0x58;

        [DllImport("user32.dll")]
        private static extern bool RegisterHotKey(IntPtr hWnd, int id, uint fsModifiers, uint vk);
        [DllImport("user32.dll")]
        private static extern bool UnregisterHotKey(IntPtr hWnd, int id);
    }
}
