﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Runtime.InteropServices;
using System.Runtime.Versioning; // để kiểm tra trạng thái phím modifier
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Windows.Input;
//Khởi động cùng Windows
using Microsoft.Win32;
using System.IO;


namespace Tainikey
{
    public partial class frmMain : Form
    {
        private KeyboardHook hook;
        //Trạng thái bật/tắt gõ chữ Thái
        private bool isTypingEnabled = true;
        //Khởi động cùng Windows
        private const string appName = "Tainikey";
        //Chế độ nhập
        enum InputMode
        {
            None,
            SueTai,
            LaiTai
        }
        private InputMode currentMode = InputMode.None;

        private NotifyIcon trayIcon;
        private ContextMenuStrip trayMenu;
        //Hotkey
        private const int HOTKEY_TAIVIET = 1;
        private const int HOTKEY_TAIYO = 2;
        private const uint MOD_CONTROL = 0x0002;
        private const uint MOD_ALT = 0x0001;
        private const uint VK_X = 0x58; // X
        private const uint VK_J = 0x4A; // J

        public frmMain()
        {
            InitializeComponent();
            //Ẩn thanh tiêu đề
            //this.FormBorderStyle = FormBorderStyle.None;

            //Load trạng thái khởi động cùng Windows
            LoadStartupStatus();

            this.KeyPreview = true;//Key Ctrl + Alt + X

            hook = new KeyboardHook();
            hook.OnKeyPressed += Hook_OnKeyPressed;
            hook.Start();

            // Tray menu
            trayMenu = new ContextMenuStrip();
            trayMenu.Items.Add("Mở Tainikey", null, (s, e) => ShowMainWindow());
            trayMenu.Items.Add("Thoát", null, (s, e) => ExitApp());

            // --- Tạo icon khay ---
            trayIcon = new NotifyIcon
            {
                Icon = CreateTrayIcon(currentMode == InputMode.SueTai ? "T" : (currentMode == InputMode.LaiTai ? "Y": "A")),
                Text = currentMode == InputMode.SueTai ? "Tainikey - Gõ chữ Thái" : (currentMode == InputMode.LaiTai ? "Tainikey - Gõ chữ Lai Tay" : "Tainikey - Gõ chữ thường"),
                ContextMenuStrip = trayMenu,
                Visible = true
            };


            // 🟢 Xử lý click chuột
            trayIcon.MouseClick += (s, e) =>
            {
                if (e.Button == MouseButtons.Left)
                    ToggleInputMode(); // 🔹 Click đơn → đổi kiểu nhập
            };

            // 🟢 Xử lý double-click
            trayIcon.MouseDoubleClick += (s, e) =>
            {
                if (e.Button == MouseButtons.Left)
                    ShowMainWindow(); // 🔹 Double-click → mở cửa sổ chính
                ToggleInputMode(); // 🔹 Double-click → đổi kiểu nhập
            };
        }

        private void UpdateTrayIcon()
        {
            string text = "A";
            string tooltip = "Tainikey - Gõ chữ thường";

            switch (currentMode)
            {
                case InputMode.SueTai:
                    text = "T";
                    tooltip = "Tainikey - Gõ chữ Tai Viet";
                    break;

                case InputMode.LaiTai:
                    text = "Y";
                    tooltip = "Tainikey - Gõ chữ Tai Yo (Lai Tay)";
                    break;
            }

            trayIcon.Icon = CreateTrayIcon(text);
            trayIcon.Text = tooltip;
        }

        private void ExitApp()
        {
            trayIcon.Visible = false;
            hook.Stop();
            Application.Exit();
        }

        private Icon CreateTrayIcon(string text)
        {
            using (Bitmap bmp = new Bitmap(32, 32))
            using (Graphics g = Graphics.FromImage(bmp))
            {
                g.Clear(Color.Transparent);

                Color bg = text == "T" ? Color.FromArgb(0, 64, 0) :
                           text == "Y" ? Color.Teal :
                           Color.Red;

                g.FillRectangle(new SolidBrush(bg), 0, 0, 32, 32);

                g.DrawRectangle(new Pen(Color.White, 2), 1, 1, 30, 30);

                using (Font f = new Font("Arial", 18, FontStyle.Bold))
                using (Brush br = new SolidBrush(Color.White))
                {
                    var sf = new StringFormat { Alignment = StringAlignment.Center, LineAlignment = StringAlignment.Center };
                    g.DrawString(text, f, br, new RectangleF(0, 0, 32, 32), sf);
                }

                return Icon.FromHandle(bmp.GetHicon());
            }
        }
        [DllImport("user32.dll")]
        private static extern short GetKeyState(int keyCode);

        private const int VK_SHIFT = 0x10;

        private bool Hook_OnKeyPressed(Keys key)
        {
            bool isShiftPressed = (GetKeyState(VK_SHIFT) & 0x8000) != 0;

            if ((Control.ModifierKeys & Keys.Control) == Keys.Control)
                return false; // bỏ qua phím có Ctrl

            if (!isTypingEnabled || currentMode == InputMode.None)
                return false; // đang tắt thì không xử lý

            string output = null;

            switch (currentMode)
            {
                case InputMode.SueTai:
                    // mapping Tai Viet
                    switch (key)
                    {
                        //Hàng phím 123
                        case Keys.Oemtilde:
                            output = isShiftPressed ? "ꪧ" : "ꪦ";
                            break;
                        case Keys.D1:
                            output = isShiftPressed ? "ꫛ" : "ꫜ";
                            break;
                        case Keys.D2:
                            output = isShiftPressed ? "ꫝ" : "ꪺ";
                            break;
                        case Keys.D3:
                            output = isShiftPressed ? "꫟" : "ꪻ";
                            break;
                        case Keys.D4:
                            output = isShiftPressed ? "ꪹ" : "ꪹ";
                            break;
                        case Keys.D5:
                            output = isShiftPressed ? "꫚" : "꫞";
                            break;
                        case Keys.D6:
                            output = isShiftPressed ? "ꪃ" : "ꪂ";
                            break;
                        case Keys.D7:
                            output = isShiftPressed ? "ꪍ" : "ꪌ";
                            break;
                        case Keys.D8:
                            output = isShiftPressed ? "ꪆ" : "ꪳ";
                            break;
                        case Keys.D9:
                            output = isShiftPressed ? "ꪇ" : "ꪸ";
                            break;
                        case Keys.D0:
                            output = isShiftPressed ? "ꪷ" : "ꪷ";
                            break;
                        case Keys.OemMinus:
                            output = isShiftPressed ? "ꪰ" : "ꪰ";
                            break;
                        case Keys.Oemplus:
                            output = isShiftPressed ? "ꪽ" : "ꪾ";
                            break;

                        // Hàng phím QWE
                        case Keys.Q:
                            output = isShiftPressed ? "ꪺ" : "ꪶ";
                            break;
                        case Keys.W:
                            output = isShiftPressed ? "ꪻ" : "ꪼ";
                            break;
                        case Keys.E:
                            output = isShiftPressed ? "꫃" : "ꪵ";
                            break;
                        case Keys.R:
                            output = isShiftPressed ? "꫁" : "꫁";
                            break;
                        case Keys.T:
                            output = isShiftPressed ? "ꪕ" : "ꪔ";
                            break;
                        case Keys.Y:
                            output = isShiftPressed ? "ꪗ" : "ꪖ";
                            break;
                        case Keys.U:
                            output = isShiftPressed ? "ꪳ" : "ꪴ";
                            break;
                        case Keys.I:
                            output = isShiftPressed ? "ꪸ" : "ꪲ";
                            break;
                        case Keys.O:
                            output = isShiftPressed ? "ꪯ" : "ꪮ";
                            break;
                        case Keys.P:
                            output = isShiftPressed ? "ꪝ" : "ꪜ";
                            break;
                        case Keys.OemOpenBrackets:
                            output = isShiftPressed ? "ꪡ" : "ꪠ";
                            break;
                        case Keys.OemCloseBrackets:
                            output = isShiftPressed ? "ꪟ" : "ꪞ";
                            break;

                        // Hàng phím ASD
                        case Keys.A:
                            output = isShiftPressed ? "꫄" : "ꪱ";
                            break;
                        case Keys.S:
                            output = isShiftPressed ? "ꪏ" : "ꪎ";
                            break;
                        case Keys.D:
                            output = isShiftPressed ? "ꪓ" : "ꪒ";
                            break;
                        case Keys.F:
                            output = isShiftPressed ? "꪿" : "꪿";
                            break;
                        case Keys.G:
                            output = isShiftPressed ? "ꪈ" : "ꪉ";
                            break;
                        case Keys.H:
                            output = isShiftPressed ? "ꪭ" : "ꪬ";
                            break;
                        case Keys.J:
                            output = isShiftPressed ? "ꪤ" : "ꪥ";
                            break;
                        case Keys.K:
                            output = isShiftPressed ? "ꪁ" : "ꪀ";
                            break;
                        case Keys.L:
                            output = isShiftPressed ? "ꪨ" : "ꪩ";
                            break;

                        // Hàng phím ZXC
                        case Keys.Z:
                            output = isShiftPressed ? "ꪐ" : "ꪑ";
                            break;
                        case Keys.X:
                            output = isShiftPressed ? "ꪅ" : "ꪄ";
                            break;
                        case Keys.C:
                            output = isShiftPressed ? "ꪋ" : "ꪊ";
                            break;
                        case Keys.V:
                            output = isShiftPressed ? "ꪪ" : "ꪫ";
                            break;
                        case Keys.B:
                            output = isShiftPressed ? "ꪛ" : "ꪚ";
                            break;
                        case Keys.N:
                            output = isShiftPressed ? "ꪘ" : "ꪙ";
                            break;
                        case Keys.M:
                            output = isShiftPressed ? "ꪢ" : "ꪣ";
                            break;

                    }
                    break;

                case InputMode.LaiTai:
                    // mapping Tai Yo
                    switch (key)
                    {
                        //Hàng phím 123
                        case Keys.Oemtilde:
                            output = isShiftPressed ? "𞛿" : "𞛿";
                            break;
                        case Keys.D1:
                            output = isShiftPressed ? "𞛮" : "𞛮";
                            break;
                        case Keys.D2:
                            output = isShiftPressed ? "𞛭" : "𞛭";
                            break;
                        case Keys.D3:
                            output = isShiftPressed ? "𞛪" : "𞛪";
                            break;
                        case Keys.D4:
                            output = isShiftPressed ? "𞛫" : "𞛫";
                            break;
                        case Keys.D5:
                            output = isShiftPressed ? "𞛩" : "𞛩";
                            break;
                        case Keys.D6:
                            output = isShiftPressed ? "𞛧" : "𞛧";
                            break;
                        case Keys.D7:
                            output = isShiftPressed ? "𞛵" : "𞛵";
                            break;
                        case Keys.D8:
                            output = isShiftPressed ? "𞛣" : "𞛣";
                            break;
                        case Keys.D9:
                            output = isShiftPressed ? "𞛢" : "𞛢";
                            break;
                        case Keys.D0:
                            output = isShiftPressed ? "𞛲" : "𞛲";
                            break;
                        case Keys.OemMinus:
                            output = isShiftPressed ? "𞛳" : "𞛳";
                            break;
                        case Keys.Oemplus:
                            output = isShiftPressed ? "𞛴" : "𞛴";
                            break;

                        // Hàng phím QWE
                        case Keys.Q:
                            output = isShiftPressed ? "𞛻" : "𞛜";
                            break;
                        case Keys.W:
                            output = isShiftPressed ? "𞛞" : "𞛝";
                            break;
                        case Keys.E:
                            output = isShiftPressed ? "𞛨" : "𞛥";
                            break;
                        case Keys.R:
                            output = isShiftPressed ? "𞛽" : "𞛽";
                            break;
                        case Keys.T:
                            output = isShiftPressed ? "𞛍" : "𞛌";
                            break;
                        case Keys.Y:
                            output = isShiftPressed ? "𞛶" : "𞛎";
                            break;
                        case Keys.U:
                            output = isShiftPressed ? "𞛤" : "𞛤";
                            break;
                        case Keys.I:
                            output = isShiftPressed ? "𞛡" : "𞛡";
                            break;
                        case Keys.O:
                            output = isShiftPressed ? "𞛾" : "𞛬";
                            break;
                        case Keys.P:
                            output = isShiftPressed ? "𞛒" : "𞛑";
                            break;
                        case Keys.OemOpenBrackets:
                            output = isShiftPressed ? "𞛷" : "𞛓";
                            break;
                        case Keys.OemCloseBrackets:
                            output = isShiftPressed ? "𞛕" : "𞛔";
                            break;

                        // Hàng phím ASD
                        case Keys.A:
                            output = isShiftPressed ? "𞛦" : "𞛠";
                            break;
                        case Keys.S:
                            output = isShiftPressed ? "𞛈" : "𞛇";
                            break;
                        case Keys.D:
                            output = isShiftPressed ? "𞛸" : "𞛋";
                            break;
                        case Keys.F:
                            output = isShiftPressed ? "𞛼" : "𞛼";
                            break;
                        case Keys.G:
                            output = isShiftPressed ? "𞛯" : "𞛅";
                            break;
                        case Keys.H:
                            output = isShiftPressed ? "𞛛" : "𞛚";
                            break;
                        case Keys.J:
                            output = isShiftPressed ? "𞛺" : "𞛗";
                            break;
                        case Keys.K:
                            output = isShiftPressed ? "𞛁" : "𞛀";
                            break;
                        case Keys.L:
                            output = isShiftPressed ? "𞛘" : "𞛘";
                            break;
                        case Keys.OemSemicolon:
                            output = isShiftPressed ? "𞜉" : "𞜉";
                            break;
                        case Keys.OemQuotes:
                            output = isShiftPressed ? "𞛄" : "𞛄";
                            break;

                        // Hàng phím ZXC
                        case Keys.Z:
                            output = isShiftPressed ? "𞛊" : "𞛉";
                            break;
                        case Keys.X:
                            output = isShiftPressed ? "𞛃" : "𞛂";
                            break;
                        case Keys.C:
                            output = isShiftPressed ? "𞛟" : "𞛆";
                            break;
                        case Keys.V:
                            output = isShiftPressed ? "𞛙" : "𞛙";
                            break;
                        case Keys.B:
                            output = isShiftPressed ? "𞛹" : "𞛐";
                            break;
                        case Keys.N:
                            output = isShiftPressed ? "𞛰" : "𞛏";
                            break;
                        case Keys.M:
                            output = isShiftPressed ? "𞛱" : "𞛖";
                            break;
                        case Keys.Oemcomma:   // phím ,
                            output = isShiftPressed ? "𞜊" : "、";
                            break;
                        case Keys.OemPeriod:  // phím .
                            output = isShiftPressed ? "𞜋" : "。";
                            break;

                    }
                    break;
            }

            if (output != null)
            {
                SendKeys.Send(output);
                return true;
            }

            return false;
        }
        
        protected override void OnFormClosing(FormClosingEventArgs e)
        {
            hook.Stop();
            UnregisterHotKey(this.Handle, HOTKEY_TAIVIET);
            UnregisterHotKey(this.Handle, HOTKEY_TAIYO);
            base.OnFormClosing(e);
        }

        private void ToggleInputMode()
        {
            // Chuyển sang chế độ tiếp theo
            switch (currentMode)
            {
                case InputMode.SueTai:
                    currentMode = InputMode.LaiTai;
                    btnToggle.Text = "Y";
                    btnToggle.BackColor = Color.Teal;
                    break;

                case InputMode.LaiTai:
                    currentMode = InputMode.None;
                    btnToggle.Text = "A";
                    btnToggle.BackColor = Color.FromArgb(192, 0, 0); // đỏ
                    break;

                case InputMode.None:
                    currentMode = InputMode.SueTai;
                    btnToggle.Text = "T";
                    btnToggle.BackColor = Color.FromArgb(0, 64, 0); // xanh đậm
                    break;
            }
            // Cập nhật biểu tượng khay hệ thống
            UpdateTrayIcon();
        }
        private void btnToggle_Click(object sender, EventArgs e)
        {
            ToggleInputMode();
        }


        private void btnHide_Click(object sender, EventArgs e)
        {
            this.Hide();
            this.ShowInTaskbar = false;
        }

        private void TrayIcon_DoubleClick(object sender, EventArgs e)
        {
            ShowMainWindow();
        }

        private void ShowMainWindow()
        {
            this.Show();
            this.ShowInTaskbar = true;
            this.WindowState = FormWindowState.Normal;
            this.Activate();
        }


        // Đóng ứng dụng từ nút "Thoát"
        private void btnClose_Click(object sender, EventArgs e)
        {
            trayIcon.Visible = false;
            hook.Stop();
            Application.Exit();
        }
        

        //Đăng ký phím tắt toàn cục(Global Hotkey)
        //1. Thêm khai báo API vào Form1.cs
        [DllImport("user32.dll")]
        public static extern bool RegisterHotKey(IntPtr hWnd, int id, uint fsModifiers, uint vk);

        [DllImport("user32.dll")]
        public static extern bool UnregisterHotKey(IntPtr hWnd, int id);


        private void frmMain_Load(object sender, EventArgs e)
        {

            string version = Application.ProductVersion;
            this.Text = "Tainikey " + version;
            RegisterHotKey(this.Handle, HOTKEY_TAIVIET, MOD_CONTROL | MOD_ALT, VK_X);
            RegisterHotKey(this.Handle, HOTKEY_TAIYO, MOD_CONTROL | MOD_ALT, VK_J);
        }


        //4. Lắng nghe hotkey trong WndProc: Ghi nhận sự kiện phím tắt toàn cục
        protected override void WndProc(ref Message m)
        {
            const int WM_HOTKEY = 0x0312;

            if (m.Msg == WM_HOTKEY)
            {
                switch (m.WParam.ToInt32())
                {
                    case HOTKEY_TAIVIET:
                        // Nếu đang ở Tai Viet → tắt
                        if (currentMode == InputMode.SueTai)
                        {
                            currentMode = InputMode.None;
                            isTypingEnabled = false;
                            btnToggle.Text = "A"; // Normal
                            btnToggle.BackColor = Color.FromArgb(192, 0, 0); // đỏ
                        }
                        else
                        {
                            currentMode = InputMode.SueTai;
                            isTypingEnabled = true;
                            btnToggle.Text = "T";
                            btnToggle.BackColor = Color.FromArgb(0, 64, 0);
                        }
                        break;

                    case HOTKEY_TAIYO:
                        // Nếu đang ở Tai Yo → tắt
                        if (currentMode == InputMode.LaiTai)
                        {
                            currentMode = InputMode.None;
                            isTypingEnabled = false;
                            btnToggle.Text = "A"; // Normal
                            btnToggle.BackColor = Color.FromArgb(192, 0, 0); // đỏ
                        }
                        else
                        {
                            currentMode = InputMode.LaiTai;
                            isTypingEnabled = true;
                            btnToggle.Text = "Y";
                            btnToggle.BackColor = Color.Teal;
                        }
                        break;
                }
                // Cập nhật biểu tượng khay hệ thống
                UpdateTrayIcon();

            }

                base.WndProc(ref m);
        }
        //Chuyển ngôn ngữ nhập khi nhấn Ctrl + Alt + X
        private void frmMain_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Control && e.Alt && e.KeyCode == Keys.X)
            {
                if (currentMode == InputMode.SueTai)
                {
                    currentMode = InputMode.None;
                    isTypingEnabled = false;
                    btnToggle.Text = "A"; // Normal
                    btnToggle.BackColor = Color.FromArgb(192, 0, 0); // đỏ
                }
                else
                {
                    currentMode = InputMode.SueTai;
                    isTypingEnabled = true;
                    btnToggle.Text = "T";
                    btnToggle.BackColor = Color.FromArgb(0, 64, 0);
                }
            }
            else if (e.Control && e.Alt && e.KeyCode == Keys.X)
            {
                if (currentMode == InputMode.LaiTai)
                {
                    currentMode = InputMode.None;
                    isTypingEnabled = false;
                    btnToggle.Text = "A"; // Normal
                    btnToggle.BackColor = Color.FromArgb(192, 0, 0); // đỏ
                }
                else
                {
                    currentMode = InputMode.LaiTai;
                    isTypingEnabled = true;
                    btnToggle.Text = "Y";
                    btnToggle.BackColor = Color.Teal;
                }

            }
            else {
                return;
            }
        }

        private void frmMain_FormClosing(object sender, FormClosingEventArgs e)
        {
            // Giải phóng tài nguyên khay hệ thống
            trayIcon.Visible = false;
            trayIcon.Dispose();
        }

        //Khởi động cùng Windows
        private void chkStartup_CheckedChanged(object sender, EventArgs e)
        {
            if (chkStartup.Checked)
                AddToStartup();
            else
                RemoveFromStartup();
        }

        private void LoadStartupStatus()
        {
            using (RegistryKey key = Registry.CurrentUser.OpenSubKey(@"Software\Microsoft\Windows\CurrentVersion\Run", false))
            {
                if (key != null)
                {
                    chkStartup.Checked = key.GetValue(appName) != null;
                }
            }
        }

        private void AddToStartup()
        {
            string exePath = Application.ExecutablePath;
            using (RegistryKey key = Registry.CurrentUser.OpenSubKey(@"Software\Microsoft\Windows\CurrentVersion\Run", true))
            {
                key.SetValue(appName, exePath);
            }
        }

        private void RemoveFromStartup()
        {
            using (RegistryKey key = Registry.CurrentUser.OpenSubKey(@"Software\Microsoft\Windows\CurrentVersion\Run", true))
            {
                if (key.GetValue(appName) != null)
                    key.DeleteValue(appName);
            }
        }

        private void btnKeyMap_Click(object sender, EventArgs e)
        {
            if (currentMode == InputMode.SueTai)
            {
                frmKM_TaiViet frmKM_TV = new frmKM_TaiViet();
                frmKM_TV.ShowDialog();
            }
            else if (currentMode == InputMode.LaiTai)
            {
                frmKM_TaiYo frmKM_TY = new frmKM_TaiYo();
                frmKM_TY.ShowDialog();
            }
            else
            {
                frmKM_TaiViet frmKM_TV = new frmKM_TaiViet();
                frmKM_TV.ShowDialog();
            }
        }

        private void btnHuongDan_Click(object sender, EventArgs e)
        {
            frmHuongDan frmHuongDan = new frmHuongDan();
            frmHuongDan.ShowDialog();
        }

        private void btnThongTin_Click(object sender, EventArgs e)
        {
            frmThongTin frmThongTin = new frmThongTin();
            frmThongTin.ShowDialog();
        }
    }
}
